﻿/*
 * Portal Gun
 * Author: Pandassaurus
 * Version: 0.1
 * Donate if you enjoy!
 * Thanks to: CamxxCore on gtaforums-c# bullet impact code, SYNTHES1SE on gta forum-moral support
 * If you're reading this, tell me! I'm curious to know how many people like having access to the code and enjoy the comments!
 */

using System;
using System.Windows.Forms;
using System.Collections.Generic;
using GTA;
using GTA.Math;
using GTA.Native;

public class PortalGun : Script
{
    //TODO: detect if above/below/side to apply correct physics, long fall boots(actual boots), portal gun sound effect
    private Prop bluePortal;
    private bool blueTeleportedRecently;
    private Prop orangePortal;
    private bool orangeTeleportedRecently;

    private bool longFallBootsOn;
    private List<Ped> orangeTPRecentlyPeds = new List<Ped>();
    List<Vehicle> orangeTpRecentlyVehicles = new List<Vehicle>();
    private List<Ped> blueTPRecentlyPeds = new List<Ped>();
    List<Vehicle> blueTpRecentlyVehicles = new List<Vehicle>();

    private Ped orangeTestPed;
    private Ped blueTestPed;

    private int orangePortalGun = WeaponHash.HeavyPistol.GetHashCode();
    private int bluePortalGun = WeaponHash.Pistol50.GetHashCode();
    
    private bool hasPlugged = false;
    private String version = "v0.1";

    public PortalGun()
    {
        Tick += OnTick;
        KeyUp += OnKeyUp;
    }

    private void OnTick(object sender, EventArgs e)
    {
        //Heart of the mod...
        AddPortals();
        CheckPlayerTeleporting();
        CheckEntityTeleporting();
        RefreshPlayerTimeouts();
        RefreshEntityTimeouts();
    }

    private void OnKeyUp(object sender, KeyEventArgs e)
    {
        var playerPed = Game.Player.Character;
        

        //TeleportPed directly to orange tpToPortal
        if (e.KeyCode == Keys.L && orangePortal != null)
        {
            playerPed.Position = orangePortal.Position + new Vector3(0, 0, 1);
            blueTeleportedRecently = true;
        }

        //TeleportPed directly to blue tpToPortal
        if (e.KeyCode == Keys.K && bluePortal != null)
        {
            playerPed.Position = bluePortal.Position + new Vector3(0, 0, 1f);
            orangeTeleportedRecently = true;
        }

        //Disables ragdoll, better for portaling
        if (e.KeyCode == Keys.J)
        {
            playerPed.CanRagdoll = !playerPed.CanRagdoll;
            UI.ShowSubtitle("Ragdoll " + playerPed.CanRagdoll);
        }

        //Long fall boots
        if (e.KeyCode == Keys.H)
        {
            if (longFallBootsOn)
            {
                //set all kinds of damage on
                Function.Call(Hash.SET_ENTITY_PROOFS, playerPed, false, false, false, false, false, false, false, false);
                UI.ShowSubtitle("Long Fall Boots Off");
                longFallBootsOn = false;
            }
            else
            {
                //set collide damage off
                Function.Call(Hash.SET_ENTITY_PROOFS, playerPed, false, false, false, true, false, false, false, false);
                UI.ShowSubtitle("Long Fall Boots On");
                longFallBootsOn = true;
            }
        }

        if (e.KeyCode == Keys.B)
        {
            //create ped
            World.CreateRandomPed(playerPed.Position + playerPed.ForwardVector*2);
        }
        if (e.KeyCode == Keys.N)
        {
            //refresh portals, in case they pop
            RefreshPortals();
        }
        if (e.KeyCode == Keys.I)
        {
            //allow switching of the blue portal gun
            if (playerPed.Weapons.Current.Hash.GetHashCode() == orangePortalGun) GTA.UI.Notify("This gun is set as the Orange Portal Gun. Choose a different gun.");
            else if(playerPed.Weapons.Current.Hash.GetHashCode() == bluePortalGun) UI.Notify("This gun is already set as the Blue Portal Gun.");
            else
            {
                bluePortalGun = playerPed.Weapons.Current.Hash.GetHashCode();
                UI.Notify("Blue Portal Gun set.");
            }
        }
        if (e.KeyCode == Keys.O)
        {
            //allow switching of the orange portal gun
            if (playerPed.Weapons.Current.Hash.GetHashCode() == bluePortalGun) GTA.UI.Notify("This gun is set as the Blue Portal Gun. Choose a different gun.");
            else if (playerPed.Weapons.Current.Hash.GetHashCode() == orangePortalGun) UI.Notify("This gun is already set as the Orange Portal Gun.");
            else
            {
                orangePortalGun = playerPed.Weapons.Current.Hash.GetHashCode();
                UI.Notify("Orange Portal Gun set.");
            }
        }
    }


    private void AddPortals()
    {
        var playerPed = Game.Player.Character;

        if (playerPed.IsShooting)
        {
            //better plug myself so that people know me
            if (Game.Player.IsPlaying && !hasPlugged)
            {
                GTA.UI.Notify("Portal Gun " + version + "\nBy Pandassaurus");
                hasPlugged = true;
            }

            //Get the Coords of the impact
            var arg = new OutputArgument();
            Function.Call(Hash.GET_PED_LAST_WEAPON_IMPACT_COORD, playerPed.Handle, arg);
            var result = arg.GetResult<Vector3>();

            //Make sure they exist
            if (result != Vector3.Zero || result != null)
            {
                var weaponHash = playerPed.Weapons.Current.Hash.GetHashCode();

                //orange tpToPortal
                if (weaponHash == orangePortalGun)
                {
                    //make sure it exists
                    if (orangePortal != null)
                    {
                        orangePortal.Delete();
                    }
                    //create model, make it mostly invincible
                    //prop_bskball_01, v_ilev_exball_grey, prop_target_orange_arrow (possible models, went with ex ball because of size)
                    orangePortal = World.CreateProp(new Model("v_ilev_exball_grey"), result, false, false);
                    Function.Call(Hash.SET_ENTITY_PROOFS, orangePortal, true, true, true, true, true, true, true, true);
                    //freeze position, blip stuff
                    orangePortal.FreezePosition = true;
                    orangePortal.AddBlip();
                    orangePortal.CurrentBlip.Color = BlipColor.Yellow;
                }

                //blue tpToPortal
                else if (weaponHash == bluePortalGun)
                {
                    //make sure it exists
                    if (bluePortal != null)
                    {
                        bluePortal.Delete();
                    }
                    //create model, make it mostly invincible
                    //prop_bowling_ball, prop_swiss_ball_01, prop_target_blue_arrow (possible models, went with ex ball because of size)
                    bluePortal = World.CreateProp(new Model("prop_swiss_ball_01"), result, false, false);
                    Function.Call(Hash.SET_ENTITY_PROOFS, bluePortal, true, true, true, true, true, true, true, true);
                    //freeze position, blip stuff
                    bluePortal.FreezePosition = true;
                    bluePortal.AddBlip();
                    bluePortal.CurrentBlip.Color = BlipColor.Blue;
                }
            }
        }
    }
    private void RefreshPortals()
    {
        //in case they pop...
        if (orangePortal != null)
        {
            //save previous location before deleting
            Vector3 opLocation = orangePortal.Position - new Vector3(0, 0, .45f);
            orangePortal.Delete();
            //create in same location, add blip stuff
            orangePortal = World.CreateProp(new Model("v_ilev_exball_grey"), opLocation, false, false);
            Function.Call(Hash.SET_ENTITY_PROOFS, orangePortal, true, true, true, true, true, true, true, true);
            orangePortal.FreezePosition = true;
            orangePortal.AddBlip();
            orangePortal.CurrentBlip.Color = BlipColor.Yellow;
        }
        if (bluePortal != null)
        {
            //save previous location before deleting
            Vector3 bpLocation = bluePortal.Position - new Vector3(0, 0, .45f);
            bluePortal.Delete();
            //create in same location, add blip stuff
            bluePortal = World.CreateProp(new Model("prop_swiss_ball_01"), bpLocation, false, false);
            Function.Call(Hash.SET_ENTITY_PROOFS, bluePortal, true, true, true, true, true, true, true, true);
            bluePortal.FreezePosition = true;
            bluePortal.AddBlip();
            bluePortal.CurrentBlip.Color = BlipColor.Blue;
        }
    }

    void CheckPlayerTeleporting()
    {
        var playerPed = Game.Player.Character;
        //make sure they exist
        if (bluePortal != null && orangePortal != null)
        {
            //not bother checking if far
            if (playerPed.IsNearEntity(orangePortal, new Vector3(5, 5, 5)) ||
                playerPed.IsNearEntity(bluePortal, new Vector3(5, 5, 5)))
            {
                //if touching and not teleported recently, TeleportPed
                if (orangePortal.IsTouching(playerPed) && !orangeTeleportedRecently)
                {
                    TeleportPed(playerPed, bluePortal);
                    orangeTeleportedRecently = true;
                }
                //if touching and not teleported recently, TeleportPed
                else if (bluePortal.IsTouching(playerPed) && !blueTeleportedRecently)
                {
                    TeleportPed(playerPed, orangePortal);
                    blueTeleportedRecently = true;
                }
            }
        }
    }
    private void CheckEntityTeleporting()
    {
        Ped playerPed = Game.Player.Character;

        //Entity Teleporting, dont check if player is far
        if (orangePortal != null && bluePortal != null &&
            (playerPed.IsNearEntity(orangePortal, new Vector3(60, 60, 60)) ||
             playerPed.IsNearEntity(bluePortal, new Vector3(60, 60, 60))))
        {
            //get list of peds/vehicles near each portal
            List<Ped> pedsNearOrange = new List<Ped>(GetNearestPedstoPortal(true));
            List<Vehicle> vehiclesNearOrange = new List<Vehicle>(GetNearestVehiclesToPortal(true));
            List<Ped> pedsNearBlue = new List<Ped>(GetNearestPedstoPortal(false));
            List<Vehicle> vehiclesNearBlue = new List<Vehicle>(GetNearestVehiclesToPortal(false));

            //check them all if they're touching and if they're not on timeout, then send off
            foreach (Ped po in pedsNearOrange)
            {
                if (po.IsTouching(orangePortal) && !IsPedOnTimeout(po, false))
                {
                    TeleportPed(po, bluePortal);
                    orangeTPRecentlyPeds.Add(po);
                }
            }
            foreach (Vehicle vo in vehiclesNearOrange)
            {
                if (vo.IsNearEntity(orangePortal, new Vector3(.3f, .3f, .3f)) && !IsVehicleOnTimeout(vo, false))
                {
                    TeleportVehicle(vo, bluePortal);
                    orangeTpRecentlyVehicles.Add(vo);
                }
            }
            foreach (Ped pb in pedsNearBlue)
            {
                if (pb.IsTouching(bluePortal) && !IsPedOnTimeout(pb, true))
                {
                    TeleportPed(pb, orangePortal);
                    blueTPRecentlyPeds.Add(pb);
                }
            }
            foreach (Vehicle vb in vehiclesNearBlue)
            {
                if (vb.IsNearEntity(bluePortal, new Vector3(.3f, .3f, .3f)) && !IsVehicleOnTimeout(vb, true))
                {
                    TeleportVehicle(vb, orangePortal);
                    blueTpRecentlyVehicles.Add(vb);
                }
            }
        }
    }
    private void TeleportPed(Ped ped, Prop tpToPortal)
    {
        if (ped.IsInVehicle())
        {
            TeleportVehicle(ped.CurrentVehicle, tpToPortal);
            return;
        }
        //get force of how fast player was going/direction
        var force = ped.Velocity * 1.65f;
        force.Z = MakePositive(force.Z);
        if(force == Vector3.Zero) force = new Vector3(0, 0, -1);
        //check ragdoll for continuity, set position
        var wasRagdoll = ped.IsRagdoll;
        ped.Position = tpToPortal.Position + new Vector3(0, 0, .9f);
        if (wasRagdoll) Function.Call(Hash.SET_PED_TO_RAGDOLL, ped, 200, 200, 0, false, false, false);
        //apply force, set tpToPortal use reset
        ped.ApplyForce(force);
        RefreshPortals();
    }
    void TeleportVehicle(Vehicle veh, Prop tpToPortal)
    {
        //get the velocity, and make sure it's not a bad direction
        Vector3 force = veh.Velocity;
        force.Z = MakePositive(force.Z);
        if(force == Vector3.Zero) force = veh.ForwardVector * 2;

        //set position, including distance from portal so you don't fall right back in
        veh.Position = tpToPortal.Position + new Vector3(0, 0, 1f) + veh.ForwardVector * veh.Model.GetDimensions().Y;
        veh.ApplyForce(force);
        RefreshPortals();
    }

    private void RefreshPlayerTimeouts()
    {
        Ped playerPed = Game.Player.Character;
        //Resets recent TeleportPed if you go certain distance away
        if (orangePortal != null && bluePortal != null)
        {
            if (blueTeleportedRecently && !orangePortal.IsNearEntity(playerPed, new Vector3(2.5f, 2.5f, 2.5f)))
            {
                blueTeleportedRecently = false;
            }

            if (orangeTeleportedRecently && !bluePortal.IsNearEntity(playerPed, new Vector3(2.5f, 2.5f, 2.5f)))
            {
                orangeTeleportedRecently = false;
            }
        }
    }
    private void RefreshEntityTimeouts()
    {
        //goes through all the peds/vehicles on timeout, and checks if they're far enough away to get off the timeout
        if (orangeTPRecentlyPeds != null && orangeTPRecentlyPeds.Count > 0)
        {
            for (int i = orangeTPRecentlyPeds.Count - 1; i >= 0; i--)
            {
                if (!orangeTPRecentlyPeds[i].IsNearEntity(bluePortal, new Vector3(2.5f, 2.5f, 2.5f)))
                {
                    orangeTPRecentlyPeds.Remove(orangeTPRecentlyPeds[i]);
                }
            }
        }
        if (orangeTpRecentlyVehicles != null && orangeTpRecentlyVehicles.Count > 0)
        {
            for (int i = orangeTpRecentlyVehicles.Count - 1; i >= 0; i--)
            {
                if (!orangeTpRecentlyVehicles[i].IsNearEntity(bluePortal, new Vector3(3.5f, 3.5f, 3.5f)))
                {
                    orangeTpRecentlyVehicles.Remove(orangeTpRecentlyVehicles[i]);
                }
            }
        }
        if (blueTPRecentlyPeds != null && blueTPRecentlyPeds.Count > 0)
        {
            for (int i = blueTPRecentlyPeds.Count - 1; i >= 0; i--)
            {
                if (!blueTPRecentlyPeds[i].IsNearEntity(orangePortal, new Vector3(2.5f, 2.5f, 2.5f)))
                {
                    blueTPRecentlyPeds.Remove(blueTPRecentlyPeds[i]);
                }
            }
        }
        if (blueTpRecentlyVehicles != null && blueTpRecentlyVehicles.Count > 0)
        {
            for (int i = blueTpRecentlyVehicles.Count - 1; i >= 0; i--)
            {
                if (!blueTpRecentlyVehicles[i].IsNearEntity(orangePortal, new Vector3(3.5f, 3.5f, 3.5f)))
                {
                    blueTpRecentlyVehicles.Remove(blueTpRecentlyVehicles[i]);
                }
            }
        }
    }
    Ped[] GetNearestPedstoPortal(bool isOrange)
    {
        if (isOrange)
        {
            //first time setup... will always take fucking forever (im looking at you steam games) (referencing the script.wait)
            //and why the fuck can you only use a ped to get the nearby vehicles/peds? the fuck? why not an entity? this bitches be cray
            if (orangeTestPed == null)
            {
                //create the reference ped, set values
                orangeTestPed = World.CreatePed(new Model(PedHash.Crow), orangePortal.Position);
                orangeTestPed.FreezePosition = true;
                orangeTestPed.IsVisible = false;
                Script.Wait(10);
            }
            else if (!orangeTestPed.IsNearEntity(orangePortal, new Vector3(.2f, .2f, 1.2f))) orangeTestPed.Position = orangePortal.Position;
            //add portals in case player shot between then
            AddPortals();
            //return the nearby peds
            Ped[] peds = World.GetNearbyPeds(orangeTestPed, 4);
            return peds;
        }
        else
        {
            //first time setup... will always take fucking forever (im looking at you steam games) (referencing the script.wait)
            //and why the fuck can you only use a ped to get the nearby vehicles/peds? the fuck? why not an entity? this bitches be cray
            if (blueTestPed == null)
            {
                //create the reference ped, set values
                blueTestPed = World.CreatePed(new Model(PedHash.Crow), bluePortal.Position);
                blueTestPed.FreezePosition = true;
                blueTestPed.IsVisible = false;
                Script.Wait(10);
            }
            else if (!blueTestPed.IsNearEntity(bluePortal, new Vector3(.2f, .2f, 1.2f))) blueTestPed.Position = bluePortal.Position;
            //add portals in case player shot between then
            AddPortals();
            //return the nearby peds
            Ped[] peds = World.GetNearbyPeds(blueTestPed, 4);
            return peds;
        }
    }
    Vehicle[] GetNearestVehiclesToPortal(bool isOrange)
    {
        if (isOrange)
        {
            //first time setup... will always take fucking forever (im looking at you steam games) (referencing the script.wait)
            //and why the fuck can you only use a ped to get the nearby vehicles/peds? the fuck? why not an entity? this bitches be cray
            if (orangeTestPed == null)
            {
                //create the reference ped, set values
                orangeTestPed = World.CreatePed(new Model(PedHash.Crow), orangePortal.Position);
                orangeTestPed.FreezePosition = true;
                orangeTestPed.IsVisible = false;
                Script.Wait(10);
            }
            else if (!orangeTestPed.IsNearEntity(orangePortal, new Vector3(.2f, .2f, 1.2f))) orangeTestPed.Position = orangePortal.Position;
            //add portals in case player shot between then
            AddPortals();
            //return the nearby vehicles
            Vehicle[] vehs = World.GetNearbyVehicles(orangeTestPed, 4);
            return vehs;
        }
        else
        {
            //first time setup... will always take fucking forever (im looking at you steam games) (referencing the script.wait)
            //and why the fuck can you only use a ped to get the nearby vehicles/peds? the fuck? why not an entity? this bitches be cray
            if (blueTestPed == null)
            {
                //create the reference ped, set values
                blueTestPed = World.CreatePed(new Model(PedHash.Crow), bluePortal.Position);
                blueTestPed.FreezePosition = true;
                blueTestPed.IsVisible = false;
                Script.Wait(10);
            }
            else if (!blueTestPed.IsNearEntity(bluePortal, new Vector3(.2f, .2f, 1.2f))) blueTestPed.Position = bluePortal.Position;
            //add portals in case player shot between then
            AddPortals();
            //return the nearby vehicles
            Vehicle[] vehs = World.GetNearbyVehicles(blueTestPed, 4);
            return vehs;
        }
    }

    bool IsPedOnTimeout(Ped ped, bool tpFromOrange)
    {
        //goes through each ped and sees if they're on the reqested list
        foreach (Ped op in orangeTPRecentlyPeds)
        {
            if (ped.Equals(op))
            {
                if(tpFromOrange) return true;
                else return false;
            }
        }
        foreach (Ped bp in blueTPRecentlyPeds)
        {
            if (ped.Equals(bp))
            {
                if(!tpFromOrange) return true;
                else return false;
            }
        }
        return false;
    }
    bool IsVehicleOnTimeout(Vehicle veh, bool tpFromOrange)
    {
        //goes through each vehicle and sees if they're on the reqested list
        foreach (Vehicle ov in orangeTpRecentlyVehicles)
        {
            if (veh.Equals(ov))
            {
                if (tpFromOrange) return true;
                return false;
            }
        }
        foreach (Vehicle bv in blueTpRecentlyVehicles)
        {
            if (veh.Equals(bv))
            {
                if (!tpFromOrange) return true;
                return false;
            }
        }
        return false;
    }
    private static float MakePositive(float f)
    {
        //make plus not minus
        if (f < 0)
        {
            f *= -1;
        }
        return f;
    }

    //Rest in piece beautiful code. Effort was put in to make you work, but alas, you were replaced by something that was already there
    //Goodbye, friend...
    //[Deleted]
}